/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.eventmon;

import com.ibm.hwmca.base.eventmon.EventMonitorErrorIds;
import com.ibm.hwmca.base.eventmon.MonitorEditorBean;
import com.ibm.hwmca.base.eventmon.MonitorSummaryBean;
import com.ibm.hwmca.base.eventmon.TestEventGeneratorBean;
import com.ibm.hwmca.base.eventmon.TestResultsPanelBean;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.eventmon.EventDefinition;
import com.ibm.hwmca.fw.eventmon.EventMonitor;
import com.ibm.hwmca.fw.eventmon.EventMonitorConstants;
import com.ibm.hwmca.fw.eventmon.EventMonitorManager;
import com.ibm.hwmca.fw.eventmon.TestEvent;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class EventMonitorTasklet
extends HwmcaPanelTasklet
implements EventMonitorConstants,
EventMonitorErrorIds,
VetoableChangeListener {
    private static final String TRACE_MASKT = "XLISTENT";
    private static final String TRACE_MASKF = "XLISTENF";
    private static final String TRACE_MASKD = "XLISTEND";
    private static final String THIS_CLASS = "EventMonitorTasklet";
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private PanelHandler _currentHandler;
    private EventMonitorManager _manager;
    private Locale _locale;
    private ResourceBundle _resources;
    private boolean _restoreVetoed = false;
    private short _errorId = (short)6;
    private PanelHandler _monitorSummaryHandler = new PanelHandler(){

        private final void traceService(String data) {
            Trace.trace(EventMonitorTasklet.TRACE_MASKD, "EventMonitorTasklet.monitorSummaryHandler.service:  " + data);
        }

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "--> EventMonitorTasklet.monitorSummaryHandler.service:  ");
            EventMonitorTasklet.this._errorId = (short)8;
            if (request.isDisposed() || request.isCanceled()) {
                this.traceService("request is cancelled or disposed, terminating");
                EventMonitorTasklet.this.terminate(request, response);
            } else {
                String requestType = (String)request.getData("requestType");
                this.traceService("request type is " + requestType);
                if (requestType.equals("setEnabled")) {
                    EventMonitor changedMonitor = (EventMonitor)request.getData("changedMonitor");
                    Boolean enabled = (Boolean)request.getData("enabled");
                    this.traceService("setting " + changedMonitor.getName() + " to " + enabled);
                    EventMonitor monitor = EventMonitorTasklet.this._manager.getEventMonitor(changedMonitor.getName());
                    if (monitor != null) {
                        monitor.setEnabled(enabled);
                    } else {
                        this.traceService("failed to find selected event monitor");
                        EventMonitorTasklet.this.internalError("failed to find selected event monitor");
                    }
                    this.traceService("service ends with no action");
                    response.noAction();
                } else if (requestType.equals("handleEvent")) {
                    TaskActionEvent event = (TaskActionEvent)request.getData("event");
                    EventMonitor selectedMonitor = (EventMonitor)request.getData("selectedMonitor");
                    String originator = event.getElementName();
                    this.traceService("request is handleEvent, originator is " + originator);
                    if (originator.equals("CancelButton")) {
                        this.traceService("terminating request");
                        EventMonitorTasklet.this.terminate(request, response);
                    } else if (originator.equals("OKButton")) {
                        this.traceService("terminating request");
                        EventMonitorTasklet.this.terminate(request, response);
                    } else if (originator.equals("EditMonitorButton")) {
                        this.traceService("showing busy dialog");
                        EventMonitorTasklet.this.showBusyDialog();
                        MonitorEditorBean bean = EventMonitorTasklet.this.getEditorBean(selectedMonitor);
                        bean.setMonitorName(selectedMonitor.getName());
                        bean.setMonitorDescription(selectedMonitor.getDescription());
                        bean.setEditing(true);
                        EventMonitorTasklet.this.destroyBusyDialog();
                        this.traceService("MonitorEditorBean is " + bean.dump());
                        this.traceService("New service handler is the monitorEditorHandler");
                        EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorEditorHandler;
                        this.traceService("openModalChild for the MonitorEditorPanel");
                        response.openModalChild("com.ibm.hwmca.base.eventmon.res.EventMonitor", "MonitorEditorPanel", bean);
                    } else if (originator.equals("AddMonitorButton")) {
                        this.traceService("showing busy dialog");
                        EventMonitorTasklet.this.showBusyDialog();
                        MonitorEditorBean bean = EventMonitorTasklet.this.getEditorBean(selectedMonitor);
                        bean.setMonitorName("");
                        bean.setMonitorDescription("");
                        bean.setEditing(false);
                        EventMonitorTasklet.this.destroyBusyDialog();
                        this.traceService("MonitorEditorBean is " + bean.dump());
                        this.traceService("New service handler is the monitorEditorHandler");
                        EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorEditorHandler;
                        this.traceService("openModalChild for the MonitorEditorPanel");
                        response.openModalChild("com.ibm.hwmca.base.eventmon.res.EventMonitor", "MonitorEditorPanel", bean);
                    } else if (originator.equals("DeleteMonitorButton")) {
                        if (selectedMonitor == null) {
                            this.traceService("no monitor selected, ending with no action");
                            response.noAction();
                        } else {
                            this.traceService("selected monitor is " + selectedMonitor.getName());
                            this.traceService("disabling monitor and removing from the manager");
                            selectedMonitor.setEnabled(false);
                            EventMonitorTasklet.this._manager.removeEventMonitor(selectedMonitor.getName());
                            this.traceService("sending an update response with monitor set from manager");
                            HashMap<String, Map> updates = new HashMap<String, Map>();
                            updates.put("monitors", EventMonitorTasklet.this._manager.getEventMonitors());
                            response.update(updates);
                        }
                    } else if (originator.equals("TestMonitorButton")) {
                        this.traceService("applying settings to the manager");
                        EventMonitorTasklet.this.applySettingsToManager(request);
                        if (EventMonitorTasklet.this.isSmtpOk()) {
                            this.traceService("smtp settings ok, showing busy dialog");
                            EventMonitorTasklet.this.showBusyDialog();
                            TestEventGeneratorBean bean = EventMonitorTasklet.this.getTesterBean(selectedMonitor);
                            this.traceService("created tester bean " + bean.dump());
                            EventMonitorTasklet.this.destroyBusyDialog();
                            this.traceService("opening modal child TestEventGeneratorPanel");
                            response.openModalChild("com.ibm.hwmca.base.eventmon.res.EventMonitor", "TestEventGeneratorPanel", bean);
                            this.traceService("setting service handler to testMonitorHandler");
                            EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._testMonitorHandler;
                        } else {
                            this.traceService("smtp settings are bad, ending with no action");
                            response.noAction();
                        }
                    } else {
                        EventMonitorTasklet.this.internalError("unexpected originator, ending with no action");
                    }
                }
            }
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "<-- EventMonitorTasklet.monitorSummaryHandler.service:  ");
        }
    };
    private PanelHandler _monitorEditorHandler = new PanelHandler(){

        private final void traceService(String data) {
            Trace.trace(EventMonitorTasklet.TRACE_MASKD, "EventMonitorTasklet.monitorEditorHandler.service:  " + data);
        }

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "--> EventMonitorTaskletmonitorEditorHandler.service:  ");
            EventMonitorTasklet.this._errorId = (short)10;
            if (request.isDisposed() || request.isCanceled()) {
                this.traceService("request disposed or cancelled, setting service handler to monitorSummaryHandler and disposing");
                EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                response.dispose();
            } else {
                TaskActionEvent event = (TaskActionEvent)request.getData("event");
                String originator = event.getElementName();
                this.traceService("event originator is " + originator);
                if (originator.equals("OKButton")) {
                    this.traceService("creating new monitor");
                    EventMonitor newMonitor = EventMonitorTasklet.this.createNewMonitor(request);
                    if (newMonitor == null) {
                        this.traceService("create monitor returned null, returning with no action");
                        response.noAction();
                    } else {
                        Boolean isEditing = (Boolean)request.getData("editing");
                        if (isEditing.booleanValue()) {
                            try {
                                this.traceService("editing existing monitor " + newMonitor.getName());
                                EventMonitorTasklet.this._manager.editEventMonitor(newMonitor);
                                HashMap<String, Map> updates = new HashMap<String, Map>();
                                updates.put("monitors", EventMonitorTasklet.this._manager.getEventMonitors());
                                this.traceService("preparing an update containing " + updates.size() + " monitors");
                                this.traceService("setting service handler to monitorSummaryHandler");
                                EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                                this.traceService("disposing this request and updating the MonitorSummaryPanel");
                                response.setMultipleResponseMode();
                                response.dispose();
                                response.update(updates);
                            }
                            catch (IllegalArgumentException e) {
                                EventMonitorTasklet.this.internalError("failed to find the event monitor that was edited");
                            }
                        } else {
                            try {
                                this.traceService("adding new monitor " + newMonitor.getName());
                                EventMonitorTasklet.this._manager.addEventMonitor(newMonitor);
                                HashMap<String, Map> updates = new HashMap<String, Map>();
                                updates.put("monitors", EventMonitorTasklet.this._manager.getEventMonitors());
                                this.traceService("preparing an update containing " + updates.size() + " monitors");
                                this.traceService("setting service handler to monitorSummaryHandler");
                                EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                                this.traceService("disposing this request and updating the MonitorSummaryPanel");
                                response.setMultipleResponseMode();
                                response.dispose();
                                response.update(updates);
                            }
                            catch (IllegalArgumentException e) {
                                this.traceService("new monitor name " + newMonitor.getName() + " dupes an existing monitor, showing message");
                                String[] subs = new String[]{newMonitor.getName()};
                                EventMonitorTasklet.this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.dupname"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                                this.traceService("ending with no action");
                                response.noAction();
                            }
                        }
                    }
                } else if (originator.equals("CancelButton")) {
                    this.traceService("setting service handler to monitorSummaryHandler amd disposing");
                    EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                    response.dispose();
                } else {
                    EventMonitorTasklet.this.internalError("unexpected originator, ending with no action");
                }
            }
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "<-- EventMonitorTaskletmonitorEditorHandler.service:  ");
        }
    };
    private PanelHandler _testMonitorHandler = new PanelHandler(){

        private final void traceService(String data) {
            Trace.trace(EventMonitorTasklet.TRACE_MASKD, "EventMonitorTasklet.testMonitorHandler.service:  " + data);
        }

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "--> EventMonitorTasklet.testMonitorHandler.service:  ");
            EventMonitorTasklet.this._errorId = (short)11;
            if (request.isDisposed() || request.isCanceled()) {
                this.traceService("request was disposed or cancelled, setting service handler to monitorSummaryHandler");
                EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                this.traceService("disposing response");
                response.dispose();
            } else {
                TaskActionEvent event = (TaskActionEvent)request.getData("event");
                String originator = event.getElementName();
                this.traceService("event originator was " + originator);
                if (originator.equals("OKButton")) {
                    if (request.getData("objectName") == null) {
                        this.traceService("no source object selected, showing message");
                        EventMonitorTasklet.this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.notestobject"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                        this.traceService("ending with no action");
                        response.noAction();
                    } else {
                        this.traceService("showing busy dialog");
                        EventMonitorTasklet.this.showBusyDialog();
                        this.traceService("creating test event and telling manager to fire");
                        TestEvent testEvent = EventMonitorTasklet.this.createTestEvent(request);
                        EventMonitorTasklet.this._manager.fireTestEvent(testEvent, EventMonitorTasklet.this._locale);
                        TestResultsPanelBean bean = new TestResultsPanelBean();
                        bean.setTestResultsEdit(testEvent.getLog());
                        this.traceService("created TestResultsPanelBean " + bean.dump());
                        EventMonitorTasklet.this.destroyBusyDialog();
                        this.traceService("setting service handler to testResultsHandler");
                        EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._testResultsHandler;
                        this.traceService("opening TestResultsPanel");
                        response.openModalChild("com.ibm.hwmca.base.eventmon.res.EventMonitor", "testResultsPanel", bean);
                    }
                } else if (originator.equals("CancelButton")) {
                    this.traceService("setting service handler to monitorSummaryHandler and disposing response");
                    EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._monitorSummaryHandler;
                    response.dispose();
                } else {
                    EventMonitorTasklet.this.internalError("unexpected originator, ending with no action");
                }
            }
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "<-- EventMonitorTasklet.testMonitorHandler.service:  ");
        }
    };
    private PanelHandler _testResultsHandler = new PanelHandler(){

        private final void traceService(String data) {
            Trace.trace(EventMonitorTasklet.TRACE_MASKD, "EventMonitorTasklet.testResultsHandler.service:  " + data);
        }

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "--> EventMonitorTasklet.testResultsHandler.service:  ");
            EventMonitorTasklet.this._errorId = (short)12;
            if (request.isDisposed() || request.isCanceled()) {
                this.traceService("setting service handler to testMonitorHandler and disposing response");
                EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._testMonitorHandler;
                response.dispose();
            } else {
                TaskActionEvent event = (TaskActionEvent)request.getData("event");
                String originator = event.getElementName();
                this.traceService("event originator was " + originator);
                if (originator.equals("OKButton")) {
                    this.traceService("setting service handler to testMonitorHandler and disposing response");
                    EventMonitorTasklet.this._currentHandler = EventMonitorTasklet.this._testMonitorHandler;
                    response.dispose();
                } else {
                    EventMonitorTasklet.this.internalError("unexpected originator, ending with no action");
                }
            }
            Trace.trace(EventMonitorTasklet.TRACE_MASKF, "<-- EventMonitorTasklet.testResultsHandler.service:  ");
        }
    };

    public void logException(Throwable throwable) {
        this.logException(this._errorId, throwable);
    }

    public void logException(short errorId, Throwable throwable) {
        EventMonitorManager.logException(errorId, throwable);
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKF, "--> EventMonitorTasklet.init:  ");
        try {
            super.init();
            this._manager = EventMonitorManager.getManager();
            this._manager.addVetoableChangeListener(this);
            this._locale = UserContext.getCurrentUserContext().getLocale();
            if (this._locale == null) {
                this._locale = Locale.US;
            }
            this._resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", this._locale);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "EventMonitorTasklet.init:  ", e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorTasklet.init:  ");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKF, "--> EventMonitorTasklet.destroy:  ");
        try {
            super.destroy();
            this._manager.removeVetoableChangeListener(this);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "EventMonitorTasklet.destroy:  ", e);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorTasklet.destroy:  ");
    }

    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getSource() == this._manager && event.getPropertyName().equals("managerRestore")) {
            this._restoreVetoed = true;
            PropertyVetoException e = new PropertyVetoException("Monitor System Events task is running, and rejected a restore operation!", event);
            Trace.trace(TRACE_MASKD, "EventMonitorTasklet.vetoableChange:  ", e);
            throw e;
        }
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "--> EventMonitorTasklet.service:  ");
        try {
            if (request.isInitialRequest()) {
                this._errorId = (short)7;
                Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  handling initial request");
                Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  setting service handler to monitorSummaryHandler");
                this._currentHandler = this._monitorSummaryHandler;
                MonitorSummaryBean bean = new MonitorSummaryBean();
                bean.setBeanName("MonitorSummaryPanel");
                bean.setSmtpServer(this._manager.getSmtpHost());
                bean.setSmtpPort(this._manager.getSmtpPort());
                bean.setMinimumSeconds(this._manager.getMinimumTimeBetweenEmailSeconds());
                bean.setMonitors(this._manager.getEventMonitors());
                Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  monitor summary bean is " + bean.dump());
                Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  showing MonitorSummaryPanel");
                response.replace("com.ibm.hwmca.base.eventmon.res.EventMonitor", "MonitorSummaryPanel", bean);
            } else {
                if (this._restoreVetoed) {
                    Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  restore operation was vetoed");
                    this._restoreVetoed = false;
                    this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.warning.restoreVeto"), MsgType.WARNING_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                }
                Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  calling current service handler");
                this._currentHandler.service(request, response);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "EventMonitorTasklet.service:  ", e);
            this.logException(e);
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorTasklet.service:  ");
    }

    private void showBusyDialog() throws TaskletException {
        this.showBusyDialog(new LocalizableText(this._resources.getString("eventmon.busy.title")), new LocalizableText(this._resources.getString("eventmon.busy.text")));
    }

    private void internalError(String text) throws TaskletException {
        Exception e = new Exception(text);
        Trace.trace(TRACE_MASKD, "EventMonitorTasklet.internalError:  ", e);
        this.logException(e);
        throw new TaskletException(e);
    }

    private Map getObjectMap() {
        EventDefinition[] events = this._manager.getEventDefinitions();
        HashMap<String, Map> map = new HashMap<String, Map>(events.length);
        String key = null;
        Map value = null;
        for (int i = 0; i < events.length; ++i) {
            key = events[i].getItemNameInUI();
            value = this.getNameToObjectIdMap(events[i].getEventSources());
            map.put(key, value);
        }
        return map;
    }

    private Map getNameToObjectIdMap(Set objects) {
        HashMap<String, ObjectId> map = new HashMap<String, ObjectId>();
        Iterator i = objects.iterator();
        HwmcaObject object = null;
        while (i.hasNext()) {
            object = (HwmcaObject)i.next();
            String key = object.getUIInfo().getTitle(this._locale);
            ObjectId value = object.getObjectId();
            map.put(key, value);
        }
        return map;
    }

    private Set getTitleSet(Set objectIds) {
        HashSet<String> titleSet = new HashSet<String>();
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        Iterator ids = objectIds.iterator();
        HwmcaObject object = null;
        while (ids.hasNext()) {
            object = mom.get((ObjectId)ids.next());
            if (object == null) continue;
            titleSet.add(object.getUIInfo().getTitle(this._locale));
        }
        return titleSet;
    }

    private MonitorEditorBean getEditorBean(EventMonitor monitor) {
        UserContext userContext = UserContext.getCurrentUserContext();
        MonitorEditorBean bean = new MonitorEditorBean();
        bean.setSelectedMonitor(monitor);
        bean.setEmailAddresses(this._manager.getEmailStrings());
        bean.setTextFilters(this.getDefinedRegularExpressions());
        bean.setObjectMap(this.getObjectMap());
        if (monitor == null) {
            bean.setSelectedObjectNames(new HashSet());
            bean.setStartDate(Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()));
            bean.setEndDate(Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()));
            bean.setStartTime(Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()));
            bean.setEndTime(Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()));
            String[] days = new String[]{};
            bean.setDaysSelection(days);
        } else {
            bean.setSelectedObjectNames(this.getTitleSet(monitor.getObjectsToMonitor()));
            bean.setTextFilter(monitor.getPattern().pattern());
            bean.setEmailAddress(monitor.getEmailTargets());
            Calendar startDate = monitor.getStartDate() == null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : monitor.getStartDate();
            Calendar endDate = monitor.getEndDate() == null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : monitor.getEndDate();
            bean.setStartDate(startDate);
            bean.setEndDate(endDate);
            Calendar startTime = monitor.getStartTime() == null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : monitor.getStartTime();
            Calendar endTime = monitor.getEndTime() == null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : monitor.getEndTime();
            bean.setStartTime(startTime);
            bean.setEndTime(endTime);
            boolean[] activeDays = monitor.getActiveDays();
            if (activeDays != null) {
                ArrayList<Integer> days = new ArrayList<Integer>();
                for (int i = 0; i < 7; ++i) {
                    if (!activeDays[i]) continue;
                    days.add(new Integer(i));
                }
                bean.setDaysSelection(days);
            }
        }
        return bean;
    }

    private TestEventGeneratorBean getTesterBean(EventMonitor monitor) {
        TestEventGeneratorBean bean = new TestEventGeneratorBean();
        bean.setObjectMap(this.getObjectMap());
        bean.setExampleText(this.getTextExamplesForTestEvent());
        if (monitor == null) {
            bean.setSelectedEventType("StateChangesItem");
            bean.setSelectedObjectName(null);
        } else {
            try {
                bean.setSelectedEventType(monitor.getEventDefinition().getItemNameInUI());
            }
            catch (Exception e) {
                EventMonitorManager.logException((short)4, e);
                throw new RuntimeException("Could not locate event definition for " + monitor, e);
            }
            Set objectIds = monitor.getObjectsToMonitor();
            if (objectIds == null) {
                bean.setSelectedObjectName(null);
            } else {
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                HwmcaObject obj = null;
                Iterator i = objectIds.iterator();
                while (i.hasNext() && obj == null) {
                    obj = mom.get((ObjectId)i.next());
                }
                if (obj == null) {
                    bean.setSelectedObjectName(null);
                } else {
                    bean.setSelectedObjectName(obj.getUIInfo().getTitle(this._locale));
                }
            }
        }
        return bean;
    }

    private TestEvent createTestEvent(PanelTaskletRequest request) {
        String eventType = (String)request.getData("type");
        String objectName = (String)request.getData("objectName");
        Map objectMap = (Map)request.getData("objectMap");
        Map objectNameMap = (Map)objectMap.get(eventType);
        ObjectId source = (ObjectId)objectNameMap.get(objectName);
        Calendar eventTime = (Calendar)request.getData("time");
        EventMonitor.normalizeTime(eventTime);
        Calendar eventDate = (Calendar)request.getData("date");
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar when = Calendar.getInstance(userContext.getTimeZone(), this._locale);
        when.set(eventDate.get(1), eventDate.get(2), eventDate.get(5), eventTime.get(11), eventTime.get(12), eventTime.get(13));
        String text = (String)request.getData("text");
        return new TestEvent(eventType, source, when, text);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EventMonitor createNewMonitor(PanelTaskletRequest request) throws TaskletException {
        Calendar endTime;
        Calendar startTime;
        Calendar endDate;
        Calendar startDate;
        HashSet objectIds;
        EventDefinition eventDefintion;
        String email;
        Pattern pattern;
        String monitorName;
        block16: {
            monitorName = (String)request.getData("name");
            if (monitorName == null || monitorName.trim().equals("")) {
                this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.noname"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                return null;
            }
            String regex = (String)request.getData("regex");
            Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  regex from request is " + regex);
            pattern = null;
            if (regex != null) {
                try {
                    pattern = Pattern.compile(regex, 36);
                }
                catch (Exception e) {
                    Object[] subs = new String[]{regex, e.getMessage()};
                    this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.badregex", subs), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                    return null;
                }
            }
            email = (String)request.getData("email");
            Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  email from request is " + email);
            email = email == null ? "" : email.trim();
            if (email.equals("")) {
                this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.noemail"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                return null;
            }
            String eventType = (String)request.getData("type");
            EventDefinition[] events = this._manager.getEventDefinitions();
            eventDefintion = null;
            for (int i = 0; i < events.length && eventDefintion == null; ++i) {
                if (!events[i].getItemNameInUI().equals(eventType)) continue;
                eventDefintion = events[i];
            }
            List objectNames = (List)request.getData("objectNames");
            Map objectMap = (Map)request.getData("objectMap");
            Map nameToIdMap = (Map)objectMap.get(eventType);
            objectIds = new HashSet(objectNames.size());
            Iterator names = objectNames.iterator();
            while (names.hasNext()) {
                objectIds.add(nameToIdMap.get(names.next()));
            }
            if (objectIds.isEmpty()) {
                this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.noobjects"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                return null;
            }
            Boolean isLimitToDates = (Boolean)request.getData("limitToDates");
            startDate = null;
            endDate = null;
            if (isLimitToDates.booleanValue()) {
                startDate = (Calendar)request.getData("startDate");
                endDate = (Calendar)request.getData("endDate");
                if (startDate != null && endDate != null && startDate.after(endDate)) {
                    this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.dateorder"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                    return null;
                }
            }
            Boolean isLimitToTimes = (Boolean)request.getData("limitToTimes");
            startTime = null;
            endTime = null;
            if (isLimitToTimes.booleanValue()) {
                startTime = (Calendar)request.getData("startTime");
                endTime = (Calendar)request.getData("endTime");
                UserContext userContext = UserContext.getCurrentUserContext();
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
                formatter.setTimeZone(userContext.getTimeZone());
                EventMonitor.normalizeTime(startTime);
                EventMonitor.normalizeTime(endTime);
                Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  start time is " + formatter.format(startTime.getTime()));
                Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  end time is " + formatter.format(endTime.getTime()));
                if (startTime != null && endTime != null && startTime.after(endTime)) {
                    Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  start time is after endtime ");
                    if (startTime.get(9) == 1 && endTime.get(9) == 0) {
                        Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  handling the overnight case");
                        break block16;
                    } else {
                        this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.error.timeorder"), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                        return null;
                    }
                }
                Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  start time is before endtime");
            }
        }
        Boolean isLimitToDays = (Boolean)request.getData("limitToDays");
        Trace.trace(TRACE_MASKF, "EventMonitorTasklet.createNewMonitor:  limit to days is " + isLimitToDays);
        boolean[] activeDays = null;
        if (isLimitToDays.booleanValue()) {
            activeDays = new boolean[7];
            List days = (List)request.getData("days");
            Iterator i = days.iterator();
            while (i.hasNext()) {
                activeDays[((Integer)i.next()).intValue()] = true;
            }
        }
        EventMonitor monitor = eventDefintion.getMonitorInstance(monitorName.trim(), (String)request.getData("description"), false, objectIds, pattern, startTime, endTime, startDate, endDate, activeDays, email, this._locale);
        monitor.setEnabled(true);
        return monitor;
    }

    private void terminate(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.applySettingsToManager(request);
        try {
            EventMonitorTasklet eventMonitorTasklet = this;
            eventMonitorTasklet._manager.saveData();
            String sourceDataKey = new EventMonitorManager.EventMonitorCustomizableData().getCustomDataKey();
            dataRepApp.displayCustDataWarning(sourceDataKey, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isSmtpOk();
        response.terminate();
    }

    private void applySettingsToManager(PanelTaskletRequest request) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorTasklet.applySettingsToManager:  ");
        String smtpHost = (String)request.getData("smtpHost");
        Integer smtpPort = (Integer)request.getData("smtpPort");
        Integer minSecs = (Integer)request.getData("minSecs");
        Trace.trace(TRACE_MASKF, "EventMonitorTasklet.applySettingsToManager:  smtpHost is " + smtpHost);
        Trace.trace(TRACE_MASKF, "EventMonitorTasklet.applySettingsToManager:  smtpPort is " + smtpPort);
        Trace.trace(TRACE_MASKF, "EventMonitorTasklet.applySettingsToManager:  minSecs is " + minSecs);
        this._manager.setSmtpHost(smtpHost);
        if (smtpPort != null) {
            this._manager.setSmtpPort(smtpPort);
        }
        if (minSecs != null) {
            this._manager.setMinimumTimeBetweenEmailSeconds(minSecs);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorTasklet.applySettingsToManager:  ");
    }

    private boolean isSmtpOk() throws TaskletException {
        boolean result;
        if (this._manager.getSmtpHost() == null || this._manager.getSmtpHost().equals("")) {
            this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.warning.exitnosmtphost"), MsgType.WARNING_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
            result = false;
        } else if (!this._manager.isSmtpServerReachable()) {
            Object[] subs = new String[]{this._manager.getSmtpHost(), Integer.toString(this._manager.getSmtpPort())};
            this.showMessageBox(true, new LocalizableText(EventMonitorConstants.MESSAGE_RESOURCE, "task.eventmon.name"), new BaseMessageText("ntfy.warning.exitsmtp", subs), MsgType.WARNING_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    private String[] getDefinedRegularExpressions() {
        TreeSet<String> ts = new TreeSet<String>();
        Iterator<Object> i = this._manager.getEventMonitors().values().iterator();
        EventMonitor em = null;
        while (i.hasNext()) {
            em = (EventMonitor)i.next();
            ts.add(em.getPattern().pattern());
        }
        ts.addAll(this.getExampleRegularExpressions());
        String[] regexStrings = new String[ts.size()];
        i = ts.iterator();
        int count = 0;
        while (i.hasNext()) {
            String regex = (String)i.next();
            regexStrings[count++] = regex;
        }
        return regexStrings;
    }

    private List getExampleRegularExpressions() {
        EventDefinition[] events = this._manager.getEventDefinitions();
        ArrayList<String> expressionList = new ArrayList<String>();
        for (int i = 0; i < events.length; ++i) {
            String[] expressions = events[i].getExampleRegularExpressions();
            for (int j = 0; j < expressions.length; ++j) {
                expressionList.add(expressions[j]);
            }
        }
        return expressionList;
    }

    private String[] getTextExamplesForTestEvent() {
        EventDefinition[] events = this._manager.getEventDefinitions();
        TreeSet<String> examples = new TreeSet<String>();
        String[] xmps = null;
        for (int i = 0; i < events.length; ++i) {
            xmps = events[i].getExampleEventText();
            if (xmps == null) continue;
            for (int j = 0; j < xmps.length; ++j) {
                examples.add(xmps[j]);
            }
        }
        int count = 0;
        String[] result = new String[examples.size()];
        Iterator i = examples.iterator();
        while (i.hasNext()) {
            result[count] = (String)i.next();
            ++count;
        }
        return result;
    }

    private String[] getTextExamplesForTestEvent(EventDefinition ed) {
        return ed.getExampleEventText();
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

